' 8VCharge Control.bas .
' It contains an 2-cell 16750 Li Ion battery and charger.
' It has an input5.5 x 2.1 coax power socket
' and an output cord with 5.5 mm x 2.1 mm coax power plug connected directly to the battery
' It has a three-color lED to indicate battery voltage
' John Saunders 12/26/2022

#picaxe 14M

' Ports
symbol RED      = 2	'Output 2, low turns on the red color of the lED - needs charging
symbol BLUE     = 3	'Output 3, low turns on the blue color of the lED 
symbol GREEN    = 4	'Output 4, low turns on the green color of the lED - charged
symbol PWMPort  = 2	'PWM output controls input current: Current = 10.12 * Dity Cycle - 112 MA (Period = 25)
symbol CurrPort = 4	'Input 4   Measures the Battery Current, Charge or Discharge = (Reading - 376)/0.6 MA
symbol BattPort = 0	'Input 0   Measures the battery voltage:; V = Count/77 - .33

'Constants
'Voltage
symbol Discharged   = 560	'Battery voltage count with (1.1 V/cell)
symbol Charging     = 608	'The battery voltage count when charging up (7.6V)
symbol BattChged    = 640	'Battery is fully charged (8.0 V)

'Current elative to zero
symbol ZeroCrrent   = 24128			'No load or charge 64 * 377

rem  MAper10PWM     = .64	'32/5 MA per unit PWM

'Duty Cycle
symbol MinDutyCycle = 20      'Enough to run the electronics and trickle charge the battery
symbol GenDutyCycle = 35	'250 MA
symbol MaxDutyCycle = 70      '500 MA

'Variables
symbol OldColor     = b0
symbol Color        = b1	'0 = all off, 2 = red, 3 = blue, 4 = green
symbol CurrCount    = b2	'0-59
symbol DutyCycle    = b3	'0umber between 0 and DCLimit - 1; higher is greater battery voltage
symbol AnalogValue  = W3
symbol ChgCurr      = W4      'Desired charging current
symbol Volts	  = W5	'The ADC output 10-bit
symbol Current      = W6	'Current Values are averaged over 64 readings

Init:
HIGH RED
HIGH BLUE
HIGH GREEN
LET CurrCount = 0
LET OldColor = 0
LET DutyCycle = MinDutyCycle
PWMOUT PWMPort,25,DutyCycle

main:
rem First get the load current
PWMOUT 2,25,20
PAUSE 2500
LET Current = 0
FOR CurrCount = 0 TO 63
	READADC10 CurrPort,AnalogValue
	LET Current = Current + AnalogValue
NEXT
SERTXD("Current = ")
IF Current < ZeroCrrent THEN
	LET Current = ZeroCrrent - Current
	SERTXD("-") 
ELSE
	LET Current = Current - ZeroCrrent
ENDIF
LET Current = Current/64
LET DutyCycle = Current*5/32		'Offset for load current
rem Now get the voltage
READADC10 BattPort,Volts
rem Get the desired pwm
IF Volts > BattChged THEN
	LET DutyCycle = DutyCycle + MinDutyCycle	
ENDIF	
IF Volts <= BattChged AND Volts > Charging THEN
	LET DutyCycle = DutyCycle + GenDutyCycle	
ENDIF
IF Volts <= Charging THEN
	LET DutyCycle = DutyCycle + MaxDutyCycle	
ENDIF	
IF DutyCycle > MaxDutyCycle THEN
	LET DutyCycle = MaxDutyCycle 
ENDIF
IF DutyCycle < MinDutyCycle THEN
	LET DutyCycle = MinDutyCycle 
ENDIF
rem Set the LED	
IF Volts > BattChged THEN
	LET Color = BLUE		
ENDIF	
IF Volts <= BattChged AND Volts > Discharged THEN
	LET Color = GREEN	
ENDIF
IF Volts <= Discharged THEN
	LET Color = RED
ENDIF	
PWMOUT 2,25,DutyCycle
SERTXD(#Current)	
SERTXD(",Voltage = ")
SERTXD(#Volts)
SERTXD(",Duty Cycle = ")
SERTXD(#DutyCycle,13,10)	
IF Color <> OldColor THEN
	HIGH BLUE
	HIGH GREEN
	HIGH RED
	LOW Color
	LET OldColor = Color
ENDIF
PAUSE 60000
GOTO main

